/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.property.VWWorkflowGeneralPanel;
import filenet.vw.toolkit.runtime.property.VWWorkflowMapPanel;
import filenet.vw.toolkit.runtime.property.VWWorkflowMilestonePanel;
import filenet.vw.toolkit.runtime.property.VWWorkflowTrackerPanel;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class VWWorkflowPropPanel
extends JPanel
implements IVWPropertyChangeListener {
    private Frame m_parentFrame = null;
    private VWTrkDataModel m_trackerDataModel = null;
    private JTabbedPane m_tabbedPane = null;
    private VWWorkflowGeneralPanel m_workflowGeneralPanel = null;
    private VWWorkflowTrackerPanel m_workflowTrackerPanel = null;
    private VWWorkflowMapPanel m_workflowMapPanel = null;
    private VWWorkflowMilestonePanel m_workflowMilestonePanel = null;
    private boolean m_bCompleted = false;
    private JTextField m_name = null;
    private JTextField m_subject = null;
    private JTextField m_baseWorkClass = null;
    private JTextArea m_description = null;
    private VWToolbarBorder m_textAreaBorder = null;

    VWWorkflowPropPanel(Frame parentFrame, VWTrkDataModel trackerDataModel) {
        try {
            this.m_parentFrame = parentFrame;
            this.m_trackerDataModel = trackerDataModel;
            this.m_workflowGeneralPanel = new VWWorkflowGeneralPanel(parentFrame, trackerDataModel);
            this.m_workflowTrackerPanel = new VWWorkflowTrackerPanel(parentFrame, trackerDataModel);
            if (trackerDataModel.isCallStepEnabled()) {
                this.m_workflowMapPanel = new VWWorkflowMapPanel(parentFrame, trackerDataModel);
            }
            this.m_workflowMilestonePanel = new VWWorkflowMilestonePanel(parentFrame, trackerDataModel);
            this.setupLayout();
        }
        catch (Throwable ex) {
            VWDebug.logException(new Exception(ex));
        }
    }

    private void setupLayout() {
        try {
            this.m_name = new JTextField();
            this.m_name.setEditable(false);
            this.m_name.setBorder(null);
            this.m_subject = new JTextField();
            this.m_subject.setEditable(false);
            this.m_subject.setBorder(null);
            this.m_baseWorkClass = new JTextField();
            this.m_baseWorkClass.setEditable(false);
            this.m_baseWorkClass.setBorder(null);
            this.m_tabbedPane = new JTabbedPane();
            this.m_tabbedPane.add(VWResource.s_general, this.m_workflowGeneralPanel);
            this.m_tabbedPane.add(VWResource.s_trackers, this.m_workflowTrackerPanel);
            if (this.m_trackerDataModel.isCallStepEnabled() && this.m_workflowMapPanel != null) {
                this.m_tabbedPane.add(VWResource.s_maps, this.m_workflowMapPanel);
                this.m_tabbedPane.addChangeListener(this.m_workflowMapPanel);
            }
            this.m_tabbedPane.add(VWResource.s_milestones, this.m_workflowMilestonePanel);
            this.m_tabbedPane.addChangeListener(this.m_workflowMilestonePanel);
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(new GridBagLayout());
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.anchor = 23;
            c.insets = new Insets(0, 1, 0, 4);
            this.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_name)), c);
            c.gridy = -1;
            this.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_subject)), c);
            c.gridx = 1;
            c.gridy = 0;
            c.weightx = 1.0;
            c.gridwidth = 1;
            c.fill = 2;
            this.add((Component)this.m_name, c);
            c.gridy = -1;
            this.add((Component)this.m_subject, c);
            c.gridx = 0;
            c.gridy = -1;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.anchor = 23;
            c.insets = new Insets(0, 1, 0, 4);
            c.fill = 2;
            c.weightx = 1.0;
            JPanel panel1 = new JPanel(new BorderLayout(10, 0));
            panel1.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_baseWorkClass)), "Before");
            panel1.add((Component)this.m_baseWorkClass, "Center");
            this.add((Component)panel1, c);
            c.gridy = -1;
            c.insets = new Insets(6, 0, 0, 0);
            c.gridx = 0;
            c.gridwidth = 2;
            c.fill = 2;
            c.weighty = 0.1;
            c.gridheight = 1;
            c.fill = 1;
            c.anchor = 10;
            this.m_textAreaBorder = new VWToolbarBorder(VWResource.s_description, 0);
            JPanel panel = this.m_textAreaBorder.getClientPanel();
            this.m_description = new JTextArea();
            panel.setLayout(new BorderLayout());
            this.m_description = new JTextArea();
            this.m_description.setLineWrap(true);
            this.m_description.setWrapStyleWord(true);
            this.m_description.setRows(5);
            this.m_description.setEditable(false);
            JScrollPane dirScrollPane = new JScrollPane(this.m_description);
            dirScrollPane.setPreferredSize(new Dimension(10, 50));
            panel.add((Component)dirScrollPane, "Center");
            this.add((Component)this.m_textAreaBorder, c);
            c.insets = new Insets(6, 0, 0, 6);
            c.weighty = 1.0;
            c.gridheight = 1;
            this.add((Component)this.m_tabbedPane, c);
        }
        catch (Throwable ex) {
            VWDebug.logException(new Exception(ex));
        }
    }

    public void initialize() {
        try {
            if (this.m_trackerDataModel.getInitState() == 6) {
                if (!this.m_trackerDataModel.isCallStepEnabled() && this.m_tabbedPane != null && this.m_workflowMapPanel != null) {
                    this.m_tabbedPane.removeChangeListener(this.m_workflowMapPanel);
                    this.m_tabbedPane.remove(this.m_workflowMapPanel);
                    this.m_workflowMapPanel = null;
                }
                Date launchDate = this.m_trackerDataModel.getLaunchDate();
                this.m_description.setText(this.m_trackerDataModel.getDescription());
                if (this.m_trackerDataModel.getSubject() != null) {
                    this.m_subject.setText(this.m_trackerDataModel.getSubject());
                }
                this.m_subject.setToolTipText(VWStringUtils.formatToolTip(this.m_trackerDataModel.getSubject(), 0));
                if (this.m_trackerDataModel.getWorkflowName() != null) {
                    this.m_name.setText(this.m_trackerDataModel.getWorkflowName());
                }
                this.m_name.setToolTipText(VWStringUtils.formatToolTip(this.m_trackerDataModel.getWorkflowName(), 0));
                if (this.m_trackerDataModel.getBaseWorkClassName() != null) {
                    this.m_baseWorkClass.setText(this.m_trackerDataModel.getBaseWorkClassName());
                }
                this.m_baseWorkClass.setToolTipText(VWStringUtils.formatToolTip(this.m_trackerDataModel.getBaseWorkClassName(), 0));
                this.m_workflowGeneralPanel.initialize();
                this.m_workflowTrackerPanel.updateInfo();
                if (this.m_workflowMapPanel != null) {
                    this.m_workflowMapPanel.initialize();
                }
                if (this.m_workflowMilestonePanel != null) {
                    this.m_workflowMilestonePanel.initialize();
                }
                VWPropertyChangeNotifier.addPropertyChangeListener(this);
            }
        }
        catch (Throwable ex) {
            VWDebug.logException(new Exception(ex));
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        Object obj = event.getSource();
        if (obj == null) {
            return;
        }
        if (obj instanceof IVWPropertyChangeSource) {
            IVWPropertyChangeSource source = (IVWPropertyChangeSource)obj;
            int type = event.getID();
            switch (type) {
                case 704: 
                case 705: 
                case 710: {
                    this.updateWorkflowPropInfo();
                }
            }
        }
    }

    private void updateWorkflowPropInfo() {
        this.m_workflowGeneralPanel.updateInfo();
        this.m_workflowTrackerPanel.updateInfo();
    }

    private void logShowException(Exception ex, String title) {
        VWDebug.logException(ex);
        String msg = ex.getLocalizedMessage();
        if (msg == null || msg.length() == 0) {
            msg = ex.getClass().getName();
        }
        JOptionPane.showMessageDialog(this.m_parentFrame, msg, title, 0, null);
    }

    public void removeReferences() {
        this.m_parentFrame = null;
        this.m_trackerDataModel = null;
        if (this.m_tabbedPane != null) {
            if (this.m_workflowMapPanel != null) {
                this.m_tabbedPane.removeChangeListener(this.m_workflowMapPanel);
            }
            if (this.m_workflowMilestonePanel != null) {
                this.m_tabbedPane.addChangeListener(this.m_workflowMilestonePanel);
            }
            for (int i = this.m_tabbedPane.getTabCount() - 1; i >= 0; --i) {
                this.m_tabbedPane.removeTabAt(i);
            }
            this.m_tabbedPane.removeAll();
            this.m_tabbedPane = null;
        }
        if (this.m_workflowGeneralPanel != null) {
            this.m_workflowGeneralPanel.removeReferences();
            this.m_workflowGeneralPanel = null;
        }
        if (this.m_workflowTrackerPanel != null) {
            this.m_workflowTrackerPanel.removeReferences();
            this.m_workflowTrackerPanel = null;
        }
        if (this.m_workflowMapPanel != null) {
            this.m_workflowMapPanel.removeReferences();
            this.m_workflowMapPanel = null;
        }
        if (this.m_workflowMilestonePanel != null) {
            this.m_workflowMilestonePanel.removeReferences();
            this.m_workflowMilestonePanel = null;
        }
        if (this.m_textAreaBorder != null) {
            this.m_textAreaBorder.removeReferences();
            this.m_textAreaBorder = null;
        }
        this.m_name = null;
        this.m_subject = null;
        this.m_description = null;
        VWPropertyChangeNotifier.removePropertyChangeListener(this);
    }
}

